#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//ich bin der kochMod01.fsh   by   bergi  
//https://www.shadertoy.com/view/MtdSRX
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/** Modulo in space (cc) 2016, stefan berke

    The structure is a single tube folded in space.

	repeat_transform() applies the modulo function to cartesian coordinates
	fan_transform_XX() applies the modulo to polar coordinates

	The glsl for the distance field is generated by a python program using this script:

    o = Tube(radius=0.1, axis=1)
    o = Fan(o, axis=2, angle=(0, 30))
    o = Repeat(o, repeat=(2,2,0))
    o = Fan(o, axis=2, angle=(0,60))
    o = Repeat(o, repeat=(5,5,0))
    o = Fan(o, axis=2, angle=(0, 90))
    o = Fan(o.set_transform(mat4().translate((0,0,6))), axis=1, angle=(0,60))
    o = Fan(o, axis=2, angle=(0, 60))
    o = Repeat(o, repeat=vec3(36,36,0))

	resulting in this branch-less tree:

    Repeat(repeat=vec3(36, 36, 0))
    \-Fan(angle=(0, 60), axis=2)
      \-Fan(angle=(0, 60), axis=1)
        \-Fan(angle=(0, 90), axis=2, transform=mat4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,6,1))
          \-Repeat(repeat=vec3(5, 5, 0))
            \-Fan(angle=(0, 60), axis=2)
              \-Repeat(repeat=vec3(2, 2, 0))
                \-Fan(angle=(0.0, 30.0), axis=2)
                  \-Tube(radius=0.1, axis=1)


	source is here: https://github.com/defgsus/pector/tree/dev-csg/csg


	be fun :)
*/

#define fragc fragColor
#define fc fragCoord
vec3 fan_transform_xy(in vec3 pos, in float center, in float range) {
    center *= 0.017453292519943295;
    range *= 0.017453292519943295;
    float start = (center - range/2.),
          ang = atan(pos.x, pos.y),
          len = length(pos.xy);
    ang = mod(ang-start, range) - range/2. + center;
    pos.xy = len * vec2(sin(ang), cos(ang));
    return pos;
}

vec3 fan_transform_xz(in vec3 pos, in float center, in float range) {
    center *= 0.017453292519943295;
    range *= 0.017453292519943295;
    float start = (center - range/2.),
          ang = atan(pos.x, pos.z),
          len = length(pos.xz);
    ang = mod(ang-start, range) - range/2. + center;
    pos.xz = len * vec2(sin(ang), cos(ang));
    return pos;
}

vec3 repeat_transform(in vec3 pos, in vec3 repeat) {
    if (repeat.x > 0.) pos.x = mod(pos.x + repeat.x/2., repeat.x) - repeat.x/2.;
    if (repeat.y > 0.) pos.y = mod(pos.y + repeat.y/2., repeat.y) - repeat.y/2.;
    if (repeat.z > 0.) pos.z = mod(pos.z + repeat.z/2., repeat.z) - repeat.z/2.;
    return pos;
}


float DE(in vec3 pos) {
    return length(fan_transform_xy(
        			repeat_transform(
                        fan_transform_xy(
                            repeat_transform(
                                fan_transform_xy(
                                    (fan_transform_xz(
                                        fan_transform_xy(
                                            repeat_transform(pos, vec3(36.0, 36.0, 0.0))
                                         , 0.0, 60.0)
                                     , 0.0, 60.0) + vec3(0.0, 0.0, -6.0))
                                 , 0.0, 90.0), vec3(5.0, 5.0, 0.0))
                            , 0.0, 60.0), vec3(2.0, 2.0, 0.0))
        				, 0.0, 30.0).xz) - 0.1;
}


vec3 DE_norm(in vec3 p)
{
    vec2 e = vec2(0.001, 0.);
    return normalize(vec3(
        DE(p + e.xyy) - DE(p - e.xyy),
        DE(p + e.yxy) - DE(p - e.yxy),
        DE(p + e.yyx) - DE(p - e.yyx) ));
}

float sphere_trace(in vec3 ro, in vec3 rd)
{
    float t = 0.;
    for (int i=0; i<70; ++i)
    {
        float d = DE(ro + rd * t);
        if (d < 0.001)
            return t;
        t += d;
        if (t > 100.)
            break;
    }
    return -1.;
}

vec3 sky_c(in vec3 rd)
{
    return mix(vec3(0.0,.1,.0)*.3,
               vec3(0.0,.5,.8)*.2, rd.y*.5+.5);
}

vec3 light(in vec3 p, in vec3 n, in vec3 refl, in vec3 lp, in vec3 co)
{
    vec3 ln = normalize(lp - p);
    float ph = max(0., dot(n, ln));
    float sh = max(0., dot(refl, ln));
    return co * pow(ph, 5.)
         + co * pow(sh, 9.) * .5;
}

mat4 camera = mat4(1);

void get_ray(in vec2 uv, out vec3 ro, out vec3 rd)
{
    ro = vec3(0,0,0);
    rd = normalize(vec3(uv, -1.2+.3*length(uv)));

    ro = (camera * vec4(ro, 1.)).xyz;
    rd = (camera * vec4(rd, 0.)).xyz;
}

vec3 render(in vec2 uv)
{
    vec3 ro, rd, col=vec3(0);
    get_ray(uv, ro, rd);
    float t = sphere_trace(ro, rd);
    if (t < 0.)
        return sqrt(sky_c(rd));

    vec3 po = ro+t*rd;
    vec3 n = DE_norm(po);
    vec3 refl = reflect(rd, n);

    float amp = 4.*max(0., sin(iTime*3.+po.x/3.+po.z));
    col += sky_c(refl)*.3;
    col += (sky_c(rd)*amp) * pow(max(0., dot(rd, refl)), 1.);
    col += light(po, n, refl, camera[3].xyz+vec3(10,10,-3), vec3(.3,.7,1.));
    col += light(po, n, refl, (camera[3] * vec4(-2,-4,10,1.)).xyz, vec3(1,.8,.5));
	
    col = mix(col, sky_c(rd), min(1., t/60.));
    return sqrt(col);
}

// some nifty helper to uniformly set the rotation of a mat2, mat3 or mat4 
void set_rot(in float deg, inout vec2 a, inout vec2 b, in vec4 sig)
{
    deg = deg / 180. * 3.14159265; vec2 sc = vec2(sin(deg), cos(deg));
    a = sc.yx * sig.xy;
    b = sc.xy * sig.zw;
}
mat4 rotate_x(in mat4 m, in float deg) { mat4 r = mat4(1); set_rot(deg, r[1].yz, r[2].yz, vec4(1,1,-1,1)); return m*r; }
mat4 rotate_y(in mat4 m, in float deg) { mat4 r = mat4(1); set_rot(deg, r[0].xz, r[2].xz, vec4(1,-1,1,1)); return m*r; }
mat4 rotate_z(in mat4 m, in float deg) { mat4 r = mat4(1); set_rot(deg, r[0].xy, r[1].xy, vec4(1,1,-1,1)); return m*r; }

//void mainImage(out vec4 fragc, in vec2 fc)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float t = iTime;
	camera = rotate_x(camera, 90.+20.*sin(t/3.)); 
	camera = rotate_y(camera, -90.+20.*sin(t/4.)); 
    camera = rotate_z(camera, sin(t/7.)*90.); 
	camera = rotate_x(camera, 20.*sin(t/1.1)); 
    camera[3].xyz = vec3(t*3., sin(t*3.141593/12.-.1)*6., sin(t/3.-1.))+0.001;
	
    // un-comment to see structure from outside
    //camera[3].z += 15.; camera = rotate_x(camera, -50.); 
    
    vec2 uv = (fc - iResolution.xy*.5) / iResolution.y * 2.;
    
    vec3 col = vec3(0.);

    col = render(uv);

    fragColor = vec4(col,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

